require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(true);

MakeDialog
{
	-- Name the modal dialog
	name="panel_difficulty",
	Bitmap
	{
		image="ui/surfaces/panel",
		x=kCenter,
		y=kCenter,
        SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
        Text
        {
            x=155,y=20,w=kMax,h=30,
			w=kMax-50,h=40,
			label="choose_difficulty",
			flags = kVAlignCenter + kHAlignLeft,
        },

		SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
		Button
		{
			x=kCenter,
			y=kCenter - 70,
			close = true,
			command=
			    function()
                    SetDifficulty(1);
			    end,
            SetStyle(CreateTextStyle(FontButtons, 28, WhiteColorAlpha128)),
            CreateText(2,2,"easylabel", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 28, BlackColor)),
            CreateText(0,0,"easylabel", 0, 0),
		},
		
		Button
		{
			x=kCenter,
			y=kCenter - 20,
			close = true,
			command=
				function()
                    SetDifficulty(2);
				end,
            SetStyle(CreateTextStyle(FontButtons, 28, WhiteColorAlpha128)),
            CreateText(2,2,"mediumlabel", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 28, BlackColor)),
            CreateText(0,0,"mediumlabel", 0, 0),
		},

		Button
		{
			x=kCenter,
			y=kCenter + 30,
			close = true,
			command=
				function()
				    SetDifficulty(3);
				end,
            SetStyle(CreateTextStyle(FontButtons, 28, WhiteColorAlpha128)),
            CreateText(2,2,"hardlabel", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 28, BlackColor)),
            CreateText(0,0,"hardlabel", 0, 0),
		},

		Button
		{
			x=kCenter,
			y=kCenter + 120,
			close = true,
            SetStyle(CreateTextStyle(FontButtons, 24, WhiteColorAlpha128)),
            CreateText(2,2,"back", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
            CreateText(0,0,"back", 0, 0),
		},
	},
}